<?php
/*
Plugin Name: Einzigste
Description: Ersetzt in den WordPress-Kommentaren viele fälschlicherweise gesteigerte Absolutadjektive (einzigste, perfekteste, idealsterweise etc). 
Author: www.einzigste.de
Version: 0.1
Author URI: https://www.einzigste.de
*/

/*
	  Copyright 2013 www.einzigste.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    For a copy of the GNU General Public License, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

	// these values can be edited from WordPress settings menu
	add_option('einzigste_number_of_replacements', '0');
	add_option('einzigste_use_on_comments', '1');
	add_option('einzigste_use_on_content', '0');
	
	add_action('admin_menu', 'einzigste_settings_menu');
	add_action('admin_init', 'einzigste_settings_init');

	add_action('wp_enqueue_scripts', 'einzigste_add_stylesheet');

	if (get_option('einzigste_use_on_content') > 0)	 {
		add_filter('the_content','filter_einzigste_replacement');
	}
	if (get_option('einzigste_use_on_comments') > 0)	 {
		add_filter('comment_text','filter_einzigste_replacement');
	}


	/**
	 * term/replacement-configuration
	 */
	function filter_einzigste_replacement($content) {
		global $wpdb;
		
		$replacement_array = array(
			"einzigste" => "einzige",
			"einzigsten" => "einzigen",
			"einzigster" => "einziger",
			"einzigstes" => "einziges",
			"entscheidendste" => "entscheidende",
			"entscheidendster" => "entscheidender",
			"entscheidendstes" => "entscheidendes",
			"idealsterweise" => "idealerweise",
			"keinster" => "keiner",
			"letzteste" => "letzte",
			"letztester" => "letzter",
			"letztestes" => "letztes",
			"optimalste" => "optimale",
			"optimalster" => "optimaler",
			"optimalstes" => "optimales",
			"perfekteste" => "perfekte",
			"perfektester" => "perfekter",
			"perfektestes" => "perfektes",
			"totalst" => "total",
			"übelst" => "übel",
			"völligst" => "völlig",
			"vollste" => "volle",
			"vollstes" => "volles"
		);

		$content = text_highlighting($content, $replacement_array);
	
		return $content;
	}

	/**
	 * highlights all given terms with its replacements in a text. term/replacement-combinations are passed as an array.
	 */
	function text_highlighting($content, $replacement_array) {
		$terms = array();
		$replacements = array();
		$link_style = 'text-decoration: none; border-bottom: 1px dotted #3672b0;';
		$word_style = 'text-decoration:line-through;';

		// round 1: all words lowercase:
		foreach ($replacement_array as $term => $replacement) {
			$terms[] = '/ ' . $term . '(?!([^<]+)?>) /';
			$replacements[] = tooltip($term, $replacement, $word_style);
		}

		// round 2: all words with ucfirst()
		foreach ($replacement_array as $term => $replacement) {
			$term = ucfirst($term);
			$replacement = ucfirst($replacement);
			$terms[] = '/ ' . $term . '(?!([^<]+)?>) /';
			$replacements[] = tooltip($term, $replacement, $word_style);
		}

    $number_of_replacements = (int) get_option('einzigste_number_of_replacements');
    $content = preg_replace($terms, $replacements, $content, (($number_of_replacements == 0) ? -1 : $number_of_replacements)); 

	  return $content;
	}
	
	
	/** 
	 * helper function
	 */
	function tooltip($term, $replacement, $word_style) {
		return ' <span style="' . $word_style . '">' . $term . '</span> <a href="https://www.einzigste.de" target="_blank" class="einzigste_tooltip">' . $replacement . '<span class="einzigste_inside"> Hier wurde ein Sprachfehler automatisch korrgiert. Klicke auf den Link, um mehr über diesen Fehler zu erfahren. </span></a> ';
	}


	function einzigste_settings_menu() {
		add_options_page(
			'Einstellungen für das "Einzigste"-Plugin', 
			'Einzigste', 
			'manage_options', 
			'einzigste_settings', 
			'einzigste_settings_page'
		);
	}
	

	function einzigste_settings_page() {
		if (!current_user_can( 'manage_options' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}
		echo '<div class="wrap">';
		echo screen_icon();
		
		echo '
			<h2>"Einzigste"-Plugin (Auto-Korrektur von Absolutadjektiven)</h2>
		
			<form method="post" action="options.php" style="margin-top: 30px;">';

			settings_fields('einzigste_settings_group');
			
			do_settings_sections('einzigste_settings');
			submit_button();
			
		echo '
			</form>
		</div>';
	}

	function einzigste_settings_init() {

		add_settings_section(
			'einzigste_settings_section_1',
			'Allgemeine Einstellungen',
			'einzigste_settings_section_1_callback',
			'einzigste_settings'
		);
		 
		add_settings_field(
			'einzigste_number_of_replacements',
			'<strong>Anzahl Ersetzungen:</strong>',
			'einzigste_number_of_replacements_input',
			'einzigste_settings',
			'einzigste_settings_section_1'
		);

		add_settings_field(
			'einzigste_use_on_comments',
			'<strong>Ersetzen in Kommentaren:</strong>',
			'einzigste_use_on_comments_input',
			'einzigste_settings',
			'einzigste_settings_section_1'
		);

		add_settings_field(
			'einzigste_use_on_content',
			'<strong>Ersetzen in Blogartikeln:</strong>',
			'einzigste_use_on_content_input',
			'einzigste_settings',
			'einzigste_settings_section_1'
		);
 
    // Register this field with our settings group.
    register_setting('einzigste_settings_group', 'einzigste_use_on_comments');
    register_setting('einzigste_settings_group', 'einzigste_use_on_content');
    register_setting('einzigste_settings_group', 'einzigste_number_of_replacements');
	}

	function einzigste_settings_section_1_callback() {
		echo('');
	}

	function einzigste_number_of_replacements_input() {
		echo('<input type="text" name="einzigste_number_of_replacements" id="einzigste_number_of_replacements" value="'. get_option('einzigste_number_of_replacements') .'" size="2" maxlength="2" /> Wie oft sollen identische Sprachfehler im selben Kommentar/Blogartikel ersetzt werden? (0 = beliebig oft)');
	}

	function einzigste_use_on_comments_input() {
		echo('<select id="einzigste_use_on_comments" name="einzigste_use_on_comments">
			<option value="1" ' . ((get_option('einzigste_use_on_comments') == 1) ? 'selected="selected"' : '') . '>Ja</option>
			<option value="0" ' . ((get_option('einzigste_use_on_comments') == 0) ? 'selected="selected"' : '') . '>Nein</option>
			</select> Sollen die gesteigerten Absolutadjektive in allen <em>Kommentaren</em> ersetzt werden?');
	}

	function einzigste_use_on_content_input() {
		echo('<select id="einzigste_use_on_content" name="einzigste_use_on_content">
			<option value="1" ' . ((get_option('einzigste_use_on_content') == 1) ? 'selected="selected"' : '') . '>Ja</option>
			<option value="0" ' . ((get_option('einzigste_use_on_content') == 0) ? 'selected="selected"' : '') . '>Nein</option>
			</select> Sollen die gesteigerten Absolutadjektive in allen <em>Blogartikeln</em> ersetzt werden?');
	}


	/**
	 * Enqueue plugin style-file for tooltip usage
	 */
	function einzigste_add_stylesheet() {
	    wp_register_style('prefix-style', plugins_url('style.css', __FILE__) );
	    wp_enqueue_style('prefix-style');
	}

?>